Require Import Coq.Arith.Peano_dec.

(** Basic Input/Output actions names *)
Inductive bio :=
| bio_ctr  : nat -> bio
.

Theorem bio_eq_dec: forall b1 b2 : bio, {b1 = b2} + {b1 <> b2}.
Proof.
  destruct b1 as [n1]. destruct b2 as [n2].
  destruct (eq_nat_dec n1 n2) ; auto.
  right. intro X. inversion X. contradiction.
Defined.

(* Some default BIOs, useful for examples. *)
Definition stdin  := bio_ctr 0.
Definition stdout := bio_ctr 1.
Definition stderr := bio_ctr 2.
Definition beep   := bio_ctr 3.
Definition led_on := bio_ctr 4.
Definition led_off:= bio_ctr 5.


