(** Cmd stands for command, i.e. a program. *)
Require Import Val.
(*Require Import Op.*)
Require Import ZArith.
Require Import Bio.
Require Import Colist.
Require Import Trace.

Inductive cmd : Set :=
| cmd_val   : val -> cmd
| cmd_let   : cmd -> (val -> cmd) -> cmd 
| cmd_app   : func -> list val -> cmd
| cmd_bio   : bio -> val -> cmd
| cmd_if    : val -> cmd -> cmd -> cmd
| cmd_skip  : cmd
.

Notation "'Clet' x := y 'in' z" := (cmd_let y (fun x => z)) (at level 51).
Notation "c1 ;; c2" := (cmd_let c1 (fun v1 => c2)) (at level 50).
Notation Cundefined := (cmd_val val_undefined).

Section bigstep.
  (* Function context. *)
  Variable fc: (func -> (list val -> cmd)).

  CoInductive big_step: cmd -> trace -> val -> Prop :=
  | step_val: forall (v: val),
      big_step (cmd_val v) conil v

  | step_let: forall (c: cmd) (f: val -> cmd) (tau1 tau2: trace)
                     (v1 v2: val),
      big_step c tau1 v1 ->
      big_step (f v1) tau2 v2 ->
      big_step (cmd_let c f) (tau1 +++ tau2) v2

  | step_app: forall (vs: list val) (f: func) (tau: trace)
                     (v: val),
      big_step ((fc f) vs) tau v ->
      big_step (cmd_app f vs) (action_no_io ::: tau) v
               
  | step_bio: forall (v: val) (b: bio) (ret: val),
      big_step (cmd_bio b v) ((action_ctr b v ret):::conil) ret

  | step_then: forall (ct ce: cmd) (tau: trace) (v: val),
      big_step ct tau v ->
      big_step (cmd_if (val_bool true) ct ce) tau v

  | step_else: forall (v_guard: val) (ct ce: cmd) (tau: trace) (v: val),
      v_guard <> val_bool true ->
      big_step ce tau v ->
      big_step (cmd_if v_guard ct ce) tau v

  | step_skip: big_step cmd_skip conil val_undefined
  .
End bigstep.
