(** Warmup-example: getchar one byte, then putchar that byte.
    For a bigger example, see ExampleTee.v.
  *)

Require Import Cmd.
Require Import Asn.
Require Import Val.
Require Import Bio.
Require Import Op.
Require Import Hoare.
Require Import Trace.
Require Import Colist.
Require Import Coq.Arith.Peano_dec.
Import Coq.Lists.List.ListNotations.
Local Open Scope list_scope.
Require Import Impl.
Require Import Heap.

(** Example program "cat_one_byte" with its contract. *)
Definition hoare_triple_quant_cat_one_byte: hoare_triple_quant :=
  fun (vs: list val) =>
    match vs with
      | [t1; c; t2; _1; t3] => {{ asn_token t1 &*&
                              asn_bio stdin t1 (val_int 0) c t2 &*&
                              asn_bio stdout t2 c _1 t3 }}
        Clet r := (cmd_bio stdin (val_int 0)) in
        cmd_bio stdout r
        {{ fun _ => asn_token t3 }}
      | _ => {{ emp }} Cundefined {{ fun _ => emp }}
    end
.

(** Function Context/definitions. *)
Definition fc (f: func) :=
  fun (args: list val) => Cundefined (* there are no functions in this example. *)
.

(** Copredicate definitions. *)
Definition copred_defs (p: copred) : list val -> asn :=
  fun _ => asn_false (* There are no copredicates in this example. *)
.

Theorem proof_tee_out : forall (vs: list val),
    @proof copred_defs fc (hoare_triple_quant_cat_one_byte vs).
Proof.
  intro vs.
  do 6 (try destruct vs ; try apply proof_emp_undefined).
  rename v into t1. rename v0 into c. rename v1 into t2.
  rename v2 into _1. rename v3 into t3.
  
  unfold hoare_triple_quant_cat_one_byte.
  eapply proof_let.
  - eapply (apply_impl impl_sepcon_assoc).
    apply proof_frame.    
    apply proof_bio.
  - intro r.
    simpl.
    apply (apply_impl impl_sepcon_assoc2).

    eapply proof_rewrite_pre with (P' := asn_token t2 &*& asn_bio stdout t2 r _1 t3).
    {
      apply asn_rewrite_impl.
      intros h H.
      inversion H.
      inversion H2 as [h2 [h3 [h_eq [H_h2 H_h3]]]].
      inversion H_h2.
      unfold binop_eq in H6.
      destruct (val_eq_dec r c) as [r_eq_c | r_neq_c] ; try inversion H6.
      rewrite <- H4 in h_eq.
      rewrite heap_plus_empty in h_eq.
      apply heap_eq_iff_eq in h_eq.
      rewrite <- h_eq in H_h3.
      rewrite r_eq_c.
      apply H_h3.
    }
    
    eapply proof_rewrite_post.
    {
      intro r'.
      apply asn_rewrite_impl.
      apply (impl_add_eq r' _1).
    }
    apply proof_bio.
Qed.
