(* Simple example to show if-then-else (no i/o) *)

Require Import Cmd.
Require Import Asn.
Require Import Val.
Require Import Bio.
Require Import Op.
Require Import Hoare.
Require Import Trace.
Require Import Colist.
Require Import Coq.Arith.Peano_dec.
Require Import Heap.
Import Coq.Lists.List.ListNotations.
Local Open Scope list_scope.
Require Import ZArith.
Require Import Coq.Logic.FunctionalExtensionality.

(* {emp} if (10 < x) then 1 else 2 {result > 0} *)
Definition hoare_triple_quant_if: hoare_triple_quant :=
  fun (vs: list val) =>
    match vs with
      | [x] => {{ emp }}
        cmd_if (binop_lt (val_int 10) x) (cmd_val (val_int 1)) (cmd_val (val_int 2))
        {{ fun ret => asn_val (binop_lt (val_int 0) ret) }}
      | _ => {{ emp }} Cundefined {{ fun _ => emp }}
    end
.
(** Function Context/definitions. *)
Definition fc (f: func) :=
  fun (args: list val) => Cundefined (* there are no functions in this example. *)
.

(** Copredicate definitions. *)
Definition copred_defs (p: copred) : list val -> asn :=
  fun _ => asn_false (* There are no copredicates in this example. *)
.

Theorem proof_if : forall (vs: list val),
    @proof copred_defs fc (hoare_triple_quant_if vs).
Proof.
  intro vs.
  do 2 (try destruct vs ; try apply proof_emp_undefined).
  destruct (val_eq_dec (binop_lt (val_int 10) v) (val_bool true)) as [case_true | case_false].
  - unfold hoare_triple_quant_if.    
    rewrite case_true.
    apply proof_then.
    apply proof_val ; auto.
  - apply proof_else.
    + assumption.
    + apply proof_val ; auto.
Qed.
