(* This is an unfinished attempt at making it easier to write examples
   by having an easy way to reorder separating conjects.
*)

Require Import Asn.
Require Import Heap.
Require Import Impl.

Section ImplMoveAsn.
  Context {copred_defs: copred -> copred_def}.

  Fixpoint put_given_at_end (big: asn) (small: asn) :=
    match big with
    | a1 &*& a2 => a1 &*& (put_given_at_end a2 small)
    | a => a &*& small
    end
  .

  Definition move_first_to_end (a: asn) : asn :=
    match a with
    | a1 &*& a2 => put_given_at_end a2 a1
    | a => a
    end
  .

  Lemma put_given_at_end_lemma : forall (small big: asn) (h_big h_small: heap),
      models copred_defs h_small small ->
      models copred_defs h_big big ->
      models copred_defs (heap_plus h_small h_big) (put_given_at_end big small).
  Proof.
    induction big;
    try ( intros h_big h_small models_small models_big;
          simpl;
          constructor;
          exists h_big;
            exists h_small;
                   split ; try split ; try assumption;
                   rewrite heap_plus_commutative;
                   apply heap_eq_iff_eq;
                   reflexivity).
    intros h_big h_small models_small models_big.
    inversion models_big; subst.
    destruct H1 as [h_big1 [h_big2 [h_eq [models_big1 models_big2]]]].
    constructor.
    exists h_big1.
    exists (heap_plus h_small h_big2).
    split ; try split.
    - apply heap_eq_iff_eq in h_eq.
      rewrite h_eq.
      assert (heap_plus h_big1 (heap_plus h_small h_big2) = heap_plus (heap_plus h_big1 h_small) h_big2). {
        rewrite <- heap_plus_assoc.
        reflexivity.
      }
      rewrite <- heap_plus_assoc.
      rewrite H.
      assert (heap_plus h_small h_big1 = heap_plus h_big1 h_small). {
        apply heap_plus_commutative.
      }
      rewrite H0.
      apply heap_eq_iff_eq.
      reflexivity.
    - assumption.
    - apply IHbig2 ; assumption.
  Qed.

  Lemma move_first_to_end_lemma : forall {a: asn},
      impl copred_defs a (move_first_to_end a).
  Proof.
    intro a.
    destruct a ; try (intros h H; assumption).
    intros h H.
    inversion H ; subst.
    destruct H2 as [h_small [h_big [H_eq [models_h1 models_h2]]]].
    apply heap_eq_iff_eq in H_eq.
    rewrite H_eq.
    simpl.
    apply put_given_at_end_lemma ; assumption.
  Qed.


  Fixpoint get_last (a: asn) : asn :=
    match a with
    | a1 &*& a2 => get_last a2
    | a => a
    end
  .

  Fixpoint remove_last (a: asn) :=
    match a with
    | a1 &*& a2 =>
      match a2 with
      | a2x &*& a2y => a1 &*& remove_last a2
      | a => a1
      end
    | a => a
    end
  .

  Definition move_last_to_front (a: asn) :=
    match a with
    | a1 &*& a2 =>
      (get_last a) &*& (remove_last a)
    | a => a
    end
  .
End ImplMoveAsn.

(* Convert the goal models copred_defs h (a0 &*& a1 &*& a2 &*& a3 &*& ... &*& an)
 * into a goal that is simlar, but where a_(start+length+1) is moved to after a_(start). *)
Ltac move_last_to_front_in_middle_lt :=
  match goal with
  | [ |- models ?copred_defs _ (_ &*& ?a &*& _)] => apply (impl_replace_part (@move_first_to_end_lemma copred_defs (move_last_to_front a)))
  end
.

Ltac remove_emp_back_lt :=
  match goal with
  | [ |- models ?copred_defs _ (?a)] => apply (@impl_remove_emp_back copred_defs (remove_emp_back a))
  end
.


Ltac move_asn_ start length :=
  apply impl_add_emp_front;
  apply impl_add_emp_back;
  do start apply impl_sepcon_assoc2;
  apply (impl_sepcon impl_sepcon_assoc2) ; do length apply (impl_sepcon impl_sepcon_assoc2);
  do length apply (impl_sepcon (impl_replace_front impl_sepcon_assoc));
  move_last_to_front_in_middle_lt; simpl;
  do length apply (impl_sepcon (impl_replace_front impl_sepcon_assoc2));
  apply (impl_sepcon impl_sepcon_assoc); do length apply (impl_sepcon impl_sepcon_assoc);
  do start apply impl_sepcon_assoc;
  remove_emp_back_lt;
  apply impl_remove_emp_front  
.

Tactic Notation "move_asn" integer(start) integer(length) :=
  move_asn_ start length
.
