(** Op stands for operator: plus, minus, ... *)
Require Import Val.
Require Import ZArith.

Definition unop_neg (v: val) :=
  match v with
    | val_bool b => val_bool (negb b)
    | _ => val_undefined
  end
.

Definition unop_head (v: val) :=
  match v with
  | val_list_int x => val_int (List.hd 0%Z x)
  | _ => val_undefined
  end
.

Definition unop_tail (v: val) :=
  match v with
  | val_list_int x => val_list_int (List.tail x)
  | _ => val_undefined
  end
.

Definition binop_lt (v1 v2: val) :=
  match (v1, v2) with
  | (val_int x, val_int y) => val_bool (Zlt_bool x y)
  | _ => val_undefined
  end
.

Definition binop_plus (v1 v2: val) :=
  match (v1, v2) with
  | (val_int x, val_int y) => val_int (x + y)
  | _ => val_undefined
  end
.

Definition binop_eq (v1 v2: val) :=
  if val_eq_dec v1 v2 then val_bool true else val_bool false
.

Definition binop_cons (v1 v2: val) :=
  match (v1, v2) with
    | ( val_int i, val_list_int l) => val_list_int (cons i l)
    | _ => val_undefined
  end
.

Definition binop_gte (v1 v2: val) :=
  match (v1, v2) with
  | (val_int x, val_int y) => val_bool (Zge_bool x y)
  | _ => val_undefined
  end
.

Definition binop_seq (v1 v2: val) := v2.
