(** Val stands for value *)
Require Import ZArith.
Require Import Coq.Init.Datatypes.
Require Import Coq.Sets.Ensembles.
Require Import Coq.ZArith.BinInt.
Require Import Coq.Lists.List.
Require Import Coq.Bool.BoolEq.

(** Place. *)
Inductive place := 
(* Z instead of nat to avoid Z.of_nat usage in examples. *)
| place_ctr: Z -> place
.

Theorem place_eq_dec: forall t1 t2 : place, {t1 = t2} + {t1 <> t2}.
Proof.
  destruct t1 as [z]. destruct t2 as [z0].
  destruct (Z.eq_dec z z0) as [eq | neq].
  - left. subst. reflexivity.
  - right. intro H. inversion H. contradiction.
Defined.

(** Function names. *)
Inductive func :=
| func_ctr: nat -> func
.
Theorem func_eq_dec: forall f1 f2: func, {f1 = f2} + {f1 <> f2}.
Proof.
  destruct f1 as [n1]. destruct f2 as [n2].
  destruct (eq_nat_dec n1 n2) as [eq|].
  - left. subst. reflexivity.
  - right. intro H. inversion H. contradiction.
Defined.



(** Values. *)
Inductive val :=
| val_int  : Z -> val
| val_list_int: list Z -> val
| val_bool : bool -> val
| val_place: place -> val
| val_unit : val
| val_func : func -> val
| val_undefined: val
.

Theorem val_eq_dec: forall v1 v2 : val, {v1 = v2} + {v1 <> v2}.
Proof.
  destruct v1 as [x1 | x1 | x1 | x1 | | x1 | ];
  destruct v2 as [x2 | x2 | x2 | x2 | | x2 | ];
  try (destruct (Z.eq_dec x1 x2) as [ Heq | ]);
  try (destruct (list_eq_dec Z.eq_dec x1 x2) as [ Heq | ]);
  try (destruct (bool_eq_dec x1 x2) as [ Heq | ]);
  try (destruct (bool_dec x1 x2) as [ Heq | ]);
  try (destruct (place_eq_dec x1 x2) as [ Heq | ]);
  try (destruct (func_eq_dec x1 x2) as [ Heq | ]);
  try solve [right; intro X; inversion X ; contradiction];
  try solve [left ; try rewrite Heq ; reflexivity].
Defined.
